#include <iostream>
#include <vector>
#include <array>

using namespace std;

struct segtree
{
    vector<array<char, 5>> lazy;
    vector<array<int, 5>> counter;
    
    int n;
    
    void push(int v)
    {
        array<char, 5> nl1 = lazy[v << 1], nl2 = lazy[v << 1 | 1];
        array<int, 5> nc1{0}, nc2{0};
        for (int i = 0; i < 5; ++i)
        {
            {
                for (int j = 0; j < 5; ++j)
                {
                    if (lazy[v << 1][j] == i)
                    {
                        nl1[j] = lazy[v][i];
                    }
                    if (lazy[v << 1 | 1][j] == i)
                    {
                        nl2[j] = lazy[v][i];
                    }
                }
                nc1[lazy[v][i]] += counter[v << 1][i];
                counter[v << 1][i] = 0;
                nc2[lazy[v][i]] += counter[v << 1 | 1][i];
                counter[v << 1 | 1][i] = 0;
                lazy[v][i] = i;
            }
        }
        lazy[v << 1] = nl1;
        lazy[v << 1 | 1] = nl2;
        counter[v << 1] = nc1;
        counter[v << 1 | 1] = nc2;
    }
    
    void build(int v, int l, int r, string &s)
    {
        lazy[v] = {0, 1, 2, 3, 4};
        if (l == r)
        {
            counter[v].fill(0);
            counter[v][s[l] - 'a'] = 1;
            return;
        }
        int m = (l + r) >> 1;
        build(v << 1, l, m, s);
        build(v << 1 | 1, m + 1, r, s);
        for (int i = 0; i < 5; ++i) counter[v][i] = counter[v << 1][i] + counter[v << 1 | 1][i];
    }
    
    segtree(string &s) : n((int)s.size())
    {
        lazy.resize(4 * n);
        counter.resize(4 * n);
        build(1, 0, n - 1, s);
    }
    
    int get(int val, int x, int v, int l, int r)
    {
        if (l > r || counter[v][val] < x) return -1;
        if (l == r) return l;
        push(v);
        int m = (l + r) >> 1;
        if (counter[v << 1][val] >= x) return get(val, x, v << 1, l, m);
        return get(val, x - counter[v << 1][val], v << 1 | 1, m + 1, r);
    }
    
    int get(int val, int x)
    {
        return get(val, x, 1, 0, n - 1);
    }
    
    void update(int from, int to, int a, int b, int v, int l, int r)
    {
        if (a > r || b < l) return;
        if (a == l && b == r)
        {
            for (int i = 0; i < 5; ++i)
            {
                if (lazy[v][i] == from)
                {
                    lazy[v][i] = to;
                }
            }
            counter[v][to] += counter[v][from];
            counter[v][from] = 0;
            return;
        }
        push(v);
        int m = (l + r) >> 1;
        update(from, to, a, min(b, m), v << 1, l, m);
        update(from, to, max(a, m + 1), b, v << 1 | 1, m + 1, r);
        for (int i = 0; i < 5; ++i) counter[v][i] = counter[v << 1][i] + counter[v << 1 | 1][i];
    }
    
    void update(int from, int to, int b)
    {
        update(from, to, 0, b, 1, 0, n - 1);
    }
    
    void res(int v, int l, int r, string &s)
    {
        if (l == r)
        {
            for (int i = 0; i < 5; ++i) if (counter[v][i] != 0) s += char(i + 'a');
            return;
        }
        int m = (l + r) >> 1;
        push(v);
        res(v << 1, l, m, s);
        res(v << 1 | 1, m + 1, r, s);
    }
    
    string res()
    {
        string ans = "";
        res(1, 0, n - 1, ans);
        return ans;
    }
    
};

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    string s;
    cin >> n >> m >> s;
    segtree st(s);
    while (m--)
    {
        int x;
        char a, b;
        cin >> x >> a >> b;
        st.update(a - 'a', b - 'a', st.get(a - 'a', x));
    }
    cout << st.res();
    return 0;
}
